/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client;

import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.Cache;
import okhttp3.HttpUrl;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.util.Client;
import org.rundeck.client.util.FormAuthInterceptor;
import org.rundeck.client.util.QualifiedTypeConverterFactory;
import org.rundeck.client.util.RdClientConfig;
import org.rundeck.client.util.RedirectBypassInterceptor;
import org.rundeck.client.util.SSLUtil;
import org.rundeck.client.util.StaticHeaderInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.converter.jaxb.JaxbConverterFactory;

public class RundeckClient {
    public static final String USER_AGENT = "rundeck-cli/2.0.8";
    public static final int API_VERS = 29;
    public static final Pattern API_VERS_PATTERN = Pattern.compile("^(.*)(/api/(\\d+)/?)$");
    public static final String ENV_BYPASS_URL = "RD_BYPASS_URL";
    public static final String ENV_INSECURE_SSL = "RD_INSECURE_SSL";
    public static final String ENV_INSECURE_SSL_NO_WARN = "RD_INSECURE_SSL_NO_WARN";
    public static final String ENV_INSECURE_SSL_HOSTNAME = "RD_INSECURE_SSL_HOSTNAME";
    public static final String ENV_ALT_SSL_HOSTNAME = "RD_ALT_SSL_HOSTNAME";
    public static final String ENV_HTTP_TIMEOUT = "RD_HTTP_TIMEOUT";
    public static final String ENV_HTTP_READ_TIMEOUT = "RD_HTTP_READ_TIMEOUT";
    public static final String ENV_HTTP_WRITE_TIMEOUT = "RD_HTTP_WRITE_TIMEOUT";
    public static final String ENV_HTTP_CONN_TIMEOUT = "RD_HTTP_CONN_TIMEOUT";
    public static final String ENV_HTTP_CALL_TIMEOUT = "RD_HTTP_CALL_TIMEOUT";
    public static final String ENV_CONNECT_RETRY = "RD_CONNECT_RETRY";
    public static final String RD_API_DOWNGRADE = "RD_API_DOWNGRADE";
    public static final int INSECURE_SSL_LOGGING = 2;
    public static final long DEFAULT_READ_TIMEOUT_SECONDS = 600L;
    public static final long DEFAULT_CONN_TIMEOUT_SECONDS = 120L;

    private RundeckClient() {
    }

    public static Builder<RundeckApi> builder() {
        return new Builder<RundeckApi>(RundeckApi.class);
    }

    public static Builder<RundeckApi> builder(String baseUrl, String authToken) {
        Builder<RundeckApi> rundeckApiBuilder = new Builder<RundeckApi>(RundeckApi.class);
        rundeckApiBuilder.baseUrl(baseUrl);
        rundeckApiBuilder.tokenAuth(authToken);
        return rundeckApiBuilder;
    }

    public static Builder<RundeckApi> builder(String baseUrl, String username, String password) {
        Builder<RundeckApi> rundeckApiBuilder = new Builder<RundeckApi>(RundeckApi.class);
        rundeckApiBuilder.baseUrl(baseUrl);
        rundeckApiBuilder.passwordAuth(username, password);
        return rundeckApiBuilder;
    }

    public static Client<RundeckApi> with(String baseUrl, String authToken) {
        return RundeckClient.builder(baseUrl, authToken).build();
    }

    public static Client<RundeckApi> with(String baseUrl, String username, String password) {
        return RundeckClient.builder(baseUrl, username, password).build();
    }

    public static <T> Builder<T> builder(Class<T> api) {
        return new Builder<T>(api);
    }

    private static Builder<?> configInsecureSSL(Builder<?> builder, boolean insecureSsl) {
        if (insecureSsl) {
            SSLUtil.addInsecureSsl(builder.okhttp, builder.httpLogging);
        }
        return builder;
    }

    private static Builder<?> configInsecureSSLHostname(Builder<?> builder, boolean insecureSsl) {
        if (insecureSsl) {
            SSLUtil.addInsecureSSLHostnameVerifier(builder.okhttp, builder.httpLogging);
        }
        return builder;
    }

    private static Builder<?> configAlternateSSLHostname(Builder<?> builder, String value) {
        if (null != value) {
            List collect = Arrays.stream(value.split(", *")).map(String::trim).filter(s -> !"".equals(s)).map(String::toUpperCase).collect(Collectors.toList());
            List<String> names = Collections.unmodifiableList(collect);
            SSLUtil.addAlternateSSLHostnameVerifier(builder.okhttp, builder.httpLogging, names);
        }
        return builder;
    }

    private static void configBypassUrl(Builder<?> builder, String bypassUrl) {
        if (null != bypassUrl) {
            builder.okhttp.addNetworkInterceptor(new RedirectBypassInterceptor(builder.appBaseUrl, RundeckClient.normalizeUrlPath(bypassUrl)));
        }
    }

    private static Builder<?> configLogging(Builder<?> builder, int httpLogging) {
        if (httpLogging > 0) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.values()[httpLogging % HttpLoggingInterceptor.Level.values().length]);
            builder.okhttp.addNetworkInterceptor(logging);
        }
        return builder;
    }

    private static String normalizeUrlPath(String baseUrl) {
        if (!baseUrl.matches(".*/$")) {
            return baseUrl + "/";
        }
        return baseUrl;
    }

    static interface BuildWith<T, X> {
        public void accept(T var1, X var2);
    }

    public static class Builder<A> {
        final OkHttpClient.Builder okhttp;
        String baseUrl;
        String appBaseUrl;
        int httpLogging;
        HttpUrl parseUrl;
        Integer apiVersion;
        boolean allowVersionDowngrade;
        Client.Logger logger;
        private String userAgent = "rundeck-cli/2.0.8";
        private final Class<A> api;

        Builder(Class<A> api) {
            this.api = api;
            this.okhttp = new OkHttpClient.Builder();
        }

        public <T> Builder<A> accept(BuildWith<Builder<A>, T> bw, T i) {
            bw.accept(this, (Builder)i);
            return this;
        }

        public Builder<A> config(RdClientConfig config) {
            this.logging(config.getDebugLevel());
            this.retryConnect(config.getBool(RundeckClient.ENV_CONNECT_RETRY, true));
            this.readTimeout(config.getLong(RundeckClient.ENV_HTTP_READ_TIMEOUT, 600L));
            this.connectTimeout(config.getLong(RundeckClient.ENV_HTTP_CONN_TIMEOUT, 120L));
            this.writeTimeout(config.getLong(RundeckClient.ENV_HTTP_WRITE_TIMEOUT, null));
            this.timeout(config.getLong(RundeckClient.ENV_HTTP_TIMEOUT, null));
            this.callTimeout(config.getLong(RundeckClient.ENV_HTTP_CALL_TIMEOUT, null));
            this.bypassUrl(config.getString(RundeckClient.ENV_BYPASS_URL, null));
            this.insecureSSL(config.getBool(RundeckClient.ENV_INSECURE_SSL, false));
            this.insecureSSLHostname(config.getBool(RundeckClient.ENV_INSECURE_SSL_HOSTNAME, false));
            this.alternateSSLHostname(config.getString(RundeckClient.ENV_ALT_SSL_HOSTNAME, null));
            this.allowVersionDowngrade(config.getBool(RundeckClient.RD_API_DOWNGRADE, false));
            return this;
        }

        public Builder<A> bypassUrl(String string) {
            return this.accept((x$0, x$1) -> RundeckClient.configBypassUrl(x$0, x$1), string);
        }

        public Builder<A> insecureSSL(boolean bool) {
            return this.accept((x$0, x$1) -> RundeckClient.configInsecureSSL(x$0, x$1), bool);
        }

        public Builder<A> insecureSSLHostname(boolean bool) {
            return this.accept((x$0, x$1) -> RundeckClient.configInsecureSSLHostname(x$0, x$1), bool);
        }

        public Builder<A> alternateSSLHostname(String hostnames) {
            return this.accept((x$0, x$1) -> RundeckClient.configAlternateSSLHostname(x$0, x$1), hostnames);
        }

        public Builder<A> retryConnect(Boolean retryConnect) {
            if (null != retryConnect) {
                this.okhttp.retryOnConnectionFailure(retryConnect);
            }
            return this;
        }

        public Builder<A> timeout(Long timeout2) {
            return this.readTimeout(timeout2).connectTimeout(timeout2).writeTimeout(timeout2);
        }

        public Builder<A> readTimeout(Long timeout2) {
            if (null != timeout2) {
                this.okhttp.readTimeout(timeout2, TimeUnit.SECONDS);
            }
            return this;
        }

        public Builder<A> writeTimeout(Long timeout2) {
            if (null != timeout2) {
                this.okhttp.writeTimeout(timeout2, TimeUnit.SECONDS);
            }
            return this;
        }

        public Builder<A> connectTimeout(Long timeout2) {
            if (null != timeout2) {
                this.okhttp.connectTimeout(timeout2, TimeUnit.SECONDS);
            }
            return this;
        }

        public Builder<A> callTimeout(Long timeout2) {
            if (null != timeout2) {
                this.okhttp.callTimeout(timeout2, TimeUnit.SECONDS);
            }
            return this;
        }

        public Builder<A> baseUrl(String baseUrl) {
            this.parseUrl = HttpUrl.parse(baseUrl);
            Builder.validateBaseUrl(baseUrl, this.parseUrl);
            this.baseUrl = baseUrl;
            this.appBaseUrl = Builder.buildBaseAppUrlForVersion(baseUrl);
            return this;
        }

        public Builder<A> apiVersion(int version) {
            this.apiVersion = version;
            return this;
        }

        public Builder<A> allowVersionDowngrade(boolean allow) {
            this.allowVersionDowngrade = allow;
            return this;
        }

        public Builder<A> tokenAuth(String authToken) {
            Builder.buildTokenAuth(this.okhttp, this.baseUrl, authToken);
            return this;
        }

        public Builder<A> passwordAuth(String username, String password) {
            Builder.buildFormAuth(this.baseUrl, username, password, this.okhttp);
            return this;
        }

        public Client<A> build() {
            return this.buildRundeckClient();
        }

        public Builder<A> logging(int p) {
            this.httpLogging = p;
            return this.accept((x$0, x$1) -> RundeckClient.configLogging(x$0, x$1), p);
        }

        public Builder<A> logger(Client.Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder<A> userAgent(String ua) {
            this.userAgent = Builder.getUserAgent(ua);
            return this;
        }

        public static String getUserAgent(String info) {
            return String.format("%s (%s)", info, RundeckClient.USER_AGENT);
        }

        private static void buildTokenAuth(OkHttpClient.Builder builder, String baseUrl, String authToken) {
            HttpUrl parse = HttpUrl.parse(baseUrl);
            Builder.validateBaseUrl(baseUrl, parse);
            Builder.validateNotempty(authToken, "Token cannot be blank or null");
            builder.addInterceptor(new StaticHeaderInterceptor("X-Rundeck-Auth-Token", authToken));
        }

        private static void buildFormAuth(String baseUrl, String username, String password, OkHttpClient.Builder builder) {
            HttpUrl parse = HttpUrl.parse(baseUrl);
            Builder.validateBaseUrl(baseUrl, parse);
            Builder.validateNotempty(username, "User cannot be blank or null");
            Builder.validateNotempty(password, "Password cannot be blank or null");
            String appBaseUrl = Builder.buildBaseAppUrlForVersion(baseUrl);
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            builder.cookieJar(new JavaNetCookieJar(cookieManager));
            String postUrl = HttpUrl.parse(appBaseUrl).newBuilder().addPathSegment(System.getProperty("rundeck.client.j_security_check", "j_security_check")).build().toString();
            builder.addInterceptor(new FormAuthInterceptor(username, password, appBaseUrl, postUrl, System.getProperty("rundeck.client.j_username", "j_username"), System.getProperty("rundeck.client.j_password", "j_password"), System.getProperty("rundeck.client.user.error", "/user/error")));
        }

        private Client<A> buildRundeckClient() {
            String appBaseUrl = Builder.buildBaseAppUrlForVersion(this.baseUrl);
            String apiBaseUrl = null != this.apiVersion ? Builder.buildApiUrlForVersion(appBaseUrl, this.apiVersion) : Builder.buildApiUrlForVersion(this.baseUrl, 29);
            int usedApiVers = Builder.apiVersionForUrl(apiBaseUrl, 29);
            this.okhttp.addInterceptor(new StaticHeaderInterceptor("User-Agent", this.userAgent));
            OkHttpClient okhttp = this.okhttp.build();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(apiBaseUrl).client(okhttp).addConverterFactory(new QualifiedTypeConverterFactory(JacksonConverterFactory.create(), JaxbConverterFactory.create(), true)).build();
            return new Client<A>(retrofit.create(this.api), retrofit, () -> {
                okhttp.dispatcher().executorService().shutdown();
                okhttp.connectionPool().evictAll();
                Cache cache = okhttp.cache();
                if (null != cache && !cache.isClosed()) {
                    cache.close();
                }
            }, appBaseUrl, apiBaseUrl, usedApiVers, this.allowVersionDowngrade, this.logger);
        }

        private static void validateNotempty(String authToken, String s) {
            if ("".equals(authToken) || null == authToken) {
                throw new IllegalArgumentException(s);
            }
        }

        private static void validateBaseUrl(String baseUrl, HttpUrl parse) {
            if (null == parse) {
                throw new IllegalArgumentException("Not a valid base URL: " + baseUrl);
            }
        }

        private static String buildBaseAppUrlForVersion(String baseUrl) {
            Matcher matcher = API_VERS_PATTERN.matcher(baseUrl);
            if (matcher.matches()) {
                return RundeckClient.normalizeUrlPath(matcher.group(1));
            }
            return RundeckClient.normalizeUrlPath(baseUrl);
        }

        private static String buildApiUrlForVersion(String baseUrl, int apiVers) {
            if (!baseUrl.matches("^.*/api/\\d+/?$")) {
                return RundeckClient.normalizeUrlPath(baseUrl) + "api/" + apiVers + "/";
            }
            return RundeckClient.normalizeUrlPath(baseUrl);
        }

        private static int apiVersionForUrl(String baseUrl, int apiVers) {
            Matcher matcher = API_VERS_PATTERN.matcher(baseUrl);
            if (matcher.matches()) {
                return Integer.parseInt(matcher.group(3));
            }
            return apiVers;
        }
    }
}

