/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.extension;

import java.io.IOException;
import java.util.function.Function;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.ProjectInput;
import org.rundeck.client.tool.RdApp;
import org.rundeck.client.tool.extension.RdCommandExtension;
import org.rundeck.client.util.RdClientConfig;
import org.rundeck.client.util.ServiceClient;
import retrofit2.Call;

public interface RdTool {
    public <T extends RdCommandExtension> T initExtension(T var1);

    public ServiceClient<RundeckApi> getClient() throws InputError;

    public RdClientConfig getAppConfig();

    public <T> T apiCall(Function<RundeckApi, Call<T>> var1) throws InputError, IOException;

    public <T> ServiceClient.WithErrorResponse<T> apiWithErrorResponse(Function<RundeckApi, Call<T>> var1) throws InputError, IOException;

    public <T> T apiCallDowngradable(Function<RundeckApi, Call<T>> var1) throws InputError, IOException;

    public <T> ServiceClient.WithErrorResponse<T> apiWithErrorResponseDowngradable(Function<RundeckApi, Call<T>> var1) throws InputError, IOException;

    public String projectOrEnv(ProjectInput var1) throws InputError;

    public RdApp getRdApp();

    public void requireApiVersion(String var1, int var2) throws InputError;

    public static void apiVersionCheck(String description, int min, int currentVersion) throws InputError {
        if (currentVersion < min) {
            throw new InputError(String.format("%s: requires API >= %d (current: %d)", description, min, currentVersion));
        }
    }
}

