/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.ScreenScaling;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JGTable<E>
extends JTable {
    public static final String COLUMN_ALIGNMENT_HINTS_KEY = "JGTable.columnAlignmentHints";

    public JGTable() {
    }

    public JGTable(TableModel dm) {
        super(dm, null, null);
    }

    public JGTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm, null);
    }

    public JGTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public JGTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public JGTable(Vector rowData, Vector<String> columnNames) {
        super(rowData, columnNames);
    }

    public JGTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setFillsViewportHeight(true);
        this.setPreferredScrollableViewportSize(ScreenScaling.physicalDimension(450, 400));
        this.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.setDefaultEditor(Boolean.class, new BooleanEditor());
    }

    @Override
    public void updateUI() {
        this.configureEnclosingScrollPane();
        super.updateUI();
        this.setRowHeight(this.computeRowHeight());
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (c instanceof JLabel) {
            JLabel label = (JLabel)c;
            int alignment = this.getColumnAlignmentHint(this.convertColumnIndexToModel(column));
            if (alignment != -1) {
                label.setHorizontalAlignment(alignment);
            }
        }
        return c;
    }

    protected int computeRowHeight() {
        int tableFontSize = this.getFont().getSize();
        int rowHeight = tableFontSize + tableFontSize / 2 + this.getRowMargin() - 1;
        return Math.max(ScreenScaling.toPhysical(18), rowHeight);
    }

    public int[] getColumnAlignmentHints() {
        return (int[])this.getClientProperty(COLUMN_ALIGNMENT_HINTS_KEY);
    }

    public void setColumnAlignmentHints(int[] alignmentHints) {
        if (alignmentHints != null) {
            for (int i = 0; i < alignmentHints.length; ++i) {
                int hint = alignmentHints[i];
                if (hint == -1 || hint == 2 || hint == 0 || hint == 4 || hint == 10 || hint == 11) continue;
                throw new IllegalArgumentException("The hint at index " + i + " must be one of: -1, JLabel.LEFT, JLabel.CENTER, JLabel.RIGHT, JLabel.LEADING, JLabel.TRAILING.");
            }
        }
        this.putClientProperty(COLUMN_ALIGNMENT_HINTS_KEY, alignmentHints);
    }

    protected final int getColumnAlignmentHint(int columnIndex) {
        int[] hints = this.getColumnAlignmentHints();
        if (hints == null) {
            return -1;
        }
        if (hints.length == this.getColumnCount()) {
            return hints[columnIndex];
        }
        throw new IndexOutOfBoundsException(String.format("The length of the column alignment hints (%1$d) must match the table column count (%2$d).", hints.length, this.getColumnCount()));
    }

    public static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
            checkBox.setBorderPaintedFlat(true);
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.setBorderPaintedFlat(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                if (SystemUtils.isLafAqua()) {
                    super.setBackground(TRANSPARENT_COLOR);
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(NO_FOCUS_BORDER);
            }
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName)) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

