/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.util;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.JGTable;
import com.jgoodies.layout.layout.BoundedSize;
import com.jgoodies.layout.layout.ColumnSpec;
import com.jgoodies.layout.layout.ConstantSize;
import com.jgoodies.layout.layout.FormSpec;
import com.jgoodies.layout.layout.PrototypeSize;
import com.jgoodies.layout.layout.Size;
import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class TableUtils {
    private TableUtils() {
    }

    public static void resizeColumnsToPreferredWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableModel model = table.getModel();
        int columnCount = model.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = columnModel.getColumn(i);
            int preferredWidth = TableUtils.getMaximumColumnWidth(model, i);
            column.setPreferredWidth(Math.max(ScreenScaling.toPhysical(50), preferredWidth));
        }
    }

    private static int getMaximumColumnWidth(TableModel model, int column) {
        int maximumCellWidth = 0;
        int rows = model.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Object value = model.getValueAt(i, column);
            String cellString = value == null ? "" : value.toString();
            JLabel cell = new JLabel(cellString);
            int cellWidth = ((Component)cell).getPreferredSize().width;
            if (cellWidth <= maximumCellWidth) continue;
            maximumCellWidth = cellWidth;
        }
        return maximumCellWidth + ScreenScaling.toPhysical(6);
    }

    public static void configureColumns(JTable table, String encodedColumnSpecs) {
        Preconditions.checkNotNull(encodedColumnSpecs, "The %s must not be null.", "column specs");
        ColumnSpec[] specs = ColumnSpec.decodeSpecs(encodedColumnSpecs);
        TableUtils.configureColumns(table, Arrays.asList(specs));
    }

    public static void configureColumns(JTable table, List<ColumnSpec> specs) {
        Preconditions.checkNotNull(table, "The %s must not be null.", "table");
        Preconditions.checkNotNull(specs, "The %s must not be null.", "column specs");
        int columnCount = specs.size();
        Preconditions.checkArgument(table.getColumnCount() == columnCount, "Table column specifications size %d  must match the table column count %d.", columnCount, table.getColumnCount());
        int oldMode = table.getAutoResizeMode();
        table.setAutoResizeMode(0);
        int[] alignmentHints = new int[specs.size()];
        boolean hasTrueAlignmentHint = false;
        for (int i = 0; i < columnCount; ++i) {
            FormSpec.DefaultAlignment alignment;
            ColumnSpec spec = specs.get(i);
            TableColumn column = table.getColumnModel().getColumn(i);
            if (spec == null) {
                alignment = ColumnSpec.DEFAULT;
            } else {
                Size size = spec.getSize();
                if (size instanceof ConstantSize) {
                    TableUtils.configureColumnWidth(table, column, (ConstantSize)size);
                } else if (size instanceof BoundedSize) {
                    TableUtils.configureColumnWidth(table, column, (BoundedSize)size);
                } else if (size instanceof PrototypeSize) {
                    TableUtils.configureColumnWidth(table, column, (PrototypeSize)size);
                }
                alignment = spec.getDefaultAlignment();
                hasTrueAlignmentHint = hasTrueAlignmentHint || spec.getDefaultAlignmentExplictlySet();
            }
            alignmentHints[i] = TableUtils.horizontalAlignment(alignment);
        }
        table.setAutoResizeMode(oldMode);
        if (hasTrueAlignmentHint) {
            TableUtils.setColumnAlignmentHints(table, alignmentHints);
        }
    }

    private static void configureColumnWidth(JTable table, TableColumn column, ConstantSize size) {
        int width = TableUtils.pixelSize((Container)table, size);
        column.setMinWidth(width);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setResizable(false);
    }

    private static void configureColumnWidth(JTable table, TableColumn column, PrototypeSize size) {
        int width = TableUtils.pixelSize((Container)table, size);
        column.setMinWidth(width);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setResizable(false);
    }

    private static void configureColumnWidth(JTable table, TableColumn column, BoundedSize size) {
        Size basis;
        if (size.getLowerBound() != null) {
            int minWidth = TableUtils.pixelSize((Container)table, size.getLowerBound());
            column.setMinWidth(minWidth);
        }
        if (size.getUpperBound() != null) {
            int maxWidth = TableUtils.pixelSize((Container)table, size.getUpperBound());
            column.setMaxWidth(maxWidth);
        }
        if ((basis = size.getBasis()) instanceof ConstantSize || basis instanceof PrototypeSize) {
            int prefWidth = TableUtils.pixelSize((Container)table, basis);
            column.setPreferredWidth(prefWidth);
        }
        column.setResizable(true);
    }

    private static int pixelSize(Container container, Size size) {
        if (size instanceof ConstantSize) {
            return TableUtils.pixelSize(container, (ConstantSize)size);
        }
        if (size instanceof PrototypeSize) {
            return TableUtils.pixelSize(container, (PrototypeSize)size);
        }
        throw new IllegalArgumentException("Cannot convert the given size to pixels:" + size);
    }

    private static int pixelSize(Container container, ConstantSize size) {
        return size.maximumSize(container, null, null, null, null, null, true);
    }

    private static int pixelSize(Container container, PrototypeSize size) {
        return (int)((float)(ScreenScaling.toPhysical(14) + size.computeWidth(container)) + (float)size.getPrototype().length() * 0.49f);
    }

    private static int horizontalAlignment(FormSpec.DefaultAlignment alignment) {
        if (alignment == ColumnSpec.LEFT) {
            return 2;
        }
        if (alignment == ColumnSpec.CENTER) {
            return 0;
        }
        if (alignment == ColumnSpec.RIGHT) {
            return 4;
        }
        if (alignment == ColumnSpec.FILL) {
            return 10;
        }
        if (alignment == ColumnSpec.NONE) {
            return -1;
        }
        return -1;
    }

    private static void setColumnAlignmentHints(JTable table, int[] columnAlignmentHints) {
        if (table instanceof JGTable) {
            ((JGTable)table).setColumnAlignmentHints(columnAlignmentHints);
        } else {
            table.putClientProperty("JGTable.columnAlignmentHints", columnAlignmentHints);
        }
    }
}

