/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tabs;

import com.jgoodies.common.bean.ObservableBean;
import com.jgoodies.common.jsdl.action.ConsumerAction;
import com.jgoodies.common.jsdl.internal.ActionResource;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.tabs.Tab;
import com.jgoodies.fluent.tabs.TabModel;
import com.jgoodies.layout.builder.FormBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class TabBar<T extends Tab>
extends JPanel {
    public static final int DEFAULT_TAB_PREFERRED_WIDTH = 200;
    public static final int DEFAULT_TAB_MINIMUM_WIDTH = 32;
    public static final Color ACTIVE = new Color(243, 243, 243);
    private static final Color INACTIVE = new Color(216, 216, 216);
    private static final Color INACTIVE_ROLLOVER = new Color(226, 226, 226);
    private static final Color ACTION_TAB_ACTIVE = new Color(194, 194, 194);
    private static final Color TAB_SEPARATOR = new Color(170, 170, 170);
    private static IFluentResources resources = FluentResources.getInstance();
    private final TabModel<T> model;
    private final List<TabBarItem<T>> items = new ArrayList<TabBarItem<T>>();
    private final PropertyChangeListener contentChangeListener = this::onContentChange;
    private JComponent header;
    private JComponent footer;
    private TabBarActionItem newItem;
    private TabBarActionItem searchItem;
    private TabBarItem<T> draggedItem;
    private int dragStartX;
    private int dragOffsetX;
    private static final float[] DASH = new float[]{2.0f};
    private static final BasicStroke DASHED = new BasicStroke(1.0f, 0, 0, 2.0f, DASH, 0.0f);

    public TabBar(TabModel<T> model) {
        super(new FlowLayout());
        this.model = model;
        this.setBackground(Color.WHITE);
        this.initEventHandling();
        this.registerKeyboardActions();
    }

    public JComponent getHeader() {
        return this.header;
    }

    public void setHeader(JComponent header) {
        this.header = header;
        this.updateContent();
    }

    public JComponent getFooter() {
        return this.footer;
    }

    public void setFooter(JComponent footer) {
        this.footer = footer;
        this.updateContent();
    }

    private void initEventHandling() {
        this.model.addPropertyChangeListener(this.contentChangeListener);
        this.updateContent();
    }

    private void registerKeyboardActions() {
        this.registerKeyboardAction(resources.getTabBarNewTabResource(this.getLocale()).getAccelerator(), this.model::onNewTabClicked);
        this.registerKeyboardAction(resources.getTabBarCloseTabResource(this.getLocale()).getAccelerator(), this.model::closeSelectedTab);
        for (int i = 1; i < 9; ++i) {
            int index = i - 1;
            this.registerKeyboardAction("ctrl " + i, (ActionEvent evt) -> {
                if (index < this.model.size()) {
                    this.model.switchToTab(index);
                }
            });
        }
        this.registerKeyboardAction("ctrl 9", (ActionEvent evt) -> this.model.switchToLastTab());
        this.registerKeyboardAction("ctrl TAB", (ActionEvent evt) -> this.model.switchToNextTab());
        this.registerKeyboardAction("ctrl shift TAB", (ActionEvent evt) -> this.model.switchToPreviousTab());
    }

    private void registerKeyboardAction(String keystroke, Consumer<ActionEvent> handler) {
        this.registerKeyboardAction(KeyStroke.getKeyStroke(keystroke), handler);
    }

    private void registerKeyboardAction(KeyStroke keystroke, Consumer<ActionEvent> handler) {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        String command = keystroke.toString();
        inputMap.put(keystroke, command);
        actionMap.put(command, new ConsumerAction(command, handler));
    }

    private void updateContent() {
        this.releaseListeners();
        this.removeAll();
        this.items.clear();
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("pref, %1$s*(default), pref, 0:grow, pref, pref", this.model.size())).rows("f:p:g, p", new Object[0])).panel(this);
        builder.add(this.header).xy(1, 1);
        int x = 2;
        for (Tab tab : this.model.getTabs()) {
            TabBarItem<Tab> item = new TabBarItem<Tab>(this, this.model, tab);
            this.items.add(item);
            builder.add(((TabBarItem)item).buildPanel()).xy(x++, 1);
        }
        this.newItem = new TabBarActionItem(this, this.model, resources.getTabBarNewTabResource(this.getLocale()), this.model::onNewTabClicked);
        this.searchItem = new TabBarActionItem(this, this.model, resources.getTabBarSearchTabsResource(this.getLocale()), this.model::onSearchTabsClicked);
        builder.add(this.model.isEditable(), this.newItem.buildPanel()).xy(x++, 1);
        int n = ++x;
        builder.add(this.model.isTabSearchEnabled(), this.searchItem.buildPanel()).xy(n, 1);
        int n2 = ++x;
        ++x;
        builder.add(this.footer).xy(n2, 1);
        this.revalidate();
        this.repaint();
        EventQueue.invokeLater(this::updateAllRolloverState);
    }

    private void releaseListeners() {
        for (TabBarItem<T> item : this.items) {
            item.release();
        }
        if (this.newItem != null) {
            this.newItem.release();
        }
        if (this.searchItem != null) {
            this.searchItem.release();
        }
    }

    private void updateAllVisuals() {
        for (TabBarItem<T> item : this.items) {
            ((TabBarItem)item).updateVisuals();
        }
        this.newItem.updateVisuals();
        this.searchItem.updateVisuals();
    }

    private void updateAllRolloverState() {
        for (TabBarItem<T> item : this.items) {
            ((TabBarItem)item).updateRolloverState();
        }
        this.newItem.updateRolloverState();
        this.searchItem.updateRolloverState();
    }

    private void onContentChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "selectedView": {
                this.updateAllVisuals();
                break;
            }
            case "views": 
            case "editable": 
            case "tabSearchEnabled": {
                this.updateContent();
                break;
            }
        }
    }

    private boolean isDragging() {
        return this.draggedItem != null;
    }

    void tabDragged(MouseEvent evt, TabBarItem<T> item) {
        if (this.isDragging()) {
            this.dragOffsetX = evt.getX() - this.dragStartX;
            this.repaint();
            return;
        }
        if ((evt.getModifiersEx() & 0x400) != 1024) {
            return;
        }
        this.draggedItem = item;
        this.dragStartX = evt.getX();
    }

    boolean tabDragEnded(MouseEvent evt) {
        if (!this.isDragging()) {
            return false;
        }
        Rectangle bounds = ((TabBarItem)this.draggedItem).panel.getBounds();
        int x = Math.min(this.getDragMaxX(), Math.max(this.getDragMinX(), bounds.x + this.dragOffsetX));
        int insertionIndex = this.findInsertionIndex(x);
        this.model.removePropertyChangeListener(this.contentChangeListener);
        this.model.removeTab(((TabBarItem)this.draggedItem).tab);
        this.model.addTab(insertionIndex, ((TabBarItem)this.draggedItem).tab);
        this.model.setSelectedTab(((TabBarItem)this.draggedItem).tab);
        this.model.addPropertyChangeListener(this.contentChangeListener);
        this.draggedItem = null;
        this.updateAllRolloverState();
        this.updateContent();
        return true;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isDragging()) {
            return;
        }
        Rectangle bounds = ((TabBarItem)this.draggedItem).panel.getBounds();
        int x = Math.min(this.getDragMaxX(), Math.max(this.getDragMinX(), bounds.x + this.dragOffsetX));
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.DARK_GRAY);
        g2.setStroke(DASHED);
        g2.drawRect(x, 0, bounds.width - 1, bounds.height - 1);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.header != null) {
            this.header.updateUI();
        }
        if (this.footer != null) {
            this.footer.updateUI();
        }
    }

    private int getDragMinX() {
        Tab draggedTab = ((TabBarItem)this.draggedItem).tab;
        if (draggedTab.isPinned()) {
            return 0;
        }
        int minX = 0;
        for (TabBarItem<T> item : this.items) {
            Tab tab = ((TabBarItem)item).tab;
            if (tab.isPinned()) continue;
            minX = ((TabBarItem)item).panel.getX();
            break;
        }
        return minX;
    }

    private int getDragMaxX() {
        Tab draggedTab = ((TabBarItem)this.draggedItem).tab;
        if (!draggedTab.isPinned()) {
            return ((TabBarItem)this.items.get(this.items.size() - 1)).panel.getX();
        }
        int maxX = 0;
        for (TabBarItem<T> item : this.items) {
            Tab tab = ((TabBarItem)item).tab;
            if (!tab.isPinned()) continue;
            maxX = ((TabBarItem)item).panel.getX();
        }
        return maxX;
    }

    private int findInsertionIndex(int x) {
        for (int i = 0; i < this.items.size(); ++i) {
            TabBarItem<T> item = this.items.get(i);
            Rectangle bounds = ((TabBarItem)item).panel.getBounds();
            int itemX = bounds.x;
            int itemWidth = bounds.width;
            if (x >= itemX + itemWidth / 2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException ex) {
            return Locale.getDefault();
        }
    }

    private static boolean containsMouse(Component c) {
        Point mousePosition = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(mousePosition, c);
        Point location = c.getLocation();
        Rectangle bounds = c.getBounds();
        bounds.translate(-location.x, -location.y);
        return bounds.contains(mousePosition);
    }

    public static final class TabBarActionItem {
        private final Component bar;
        private final ActionResource actionResource;
        private final Consumer<EventObject> handler;
        private final MouseListener mouseHandler;
        private boolean rollover = false;
        private JLabel label;
        private JPanel panel;

        TabBarActionItem(TabBar<?> bar, TabModel<?> model, ActionResource actionResource, Consumer<EventObject> handler) {
            this.bar = bar;
            this.actionResource = actionResource;
            this.handler = handler;
            this.initComponents();
            this.mouseHandler = new MouseHandler();
            this.initEventHandling();
        }

        private void initComponents() {
            this.label = new JLabel(this.actionResource.getIcon());
            this.panel = new JPanel(null);
            this.panel.setBackground(ACTION_TAB_ACTIVE);
            this.panel.setToolTipText(this.actionResource.getMandatoryToolTipTextWithAccelerator(this.bar));
        }

        private void initEventHandling() {
            this.panel.addMouseListener(this.mouseHandler);
            this.updateVisuals();
        }

        void release() {
            this.panel.removeMouseListener(this.mouseHandler);
        }

        private JComponent buildPanel() {
            return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("center:32epx", new Object[0])).rows("c:32epx:grow", new Object[0])).panel(this.panel)).add(this.label).xy(1, 1)).build();
        }

        private void updateVisuals() {
            this.panel.setOpaque(this.rollover);
            this.panel.repaint();
        }

        private void updateRolloverState() {
            if (!this.panel.isShowing()) {
                return;
            }
            boolean oldRollover = this.rollover;
            this.rollover = TabBar.containsMouse(this.panel);
            if (oldRollover != this.rollover) {
                this.updateVisuals();
            }
        }

        private final class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                TabBarActionItem.this.handler.accept(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TabBarActionItem.this.rollover = true;
                TabBarActionItem.this.updateVisuals();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TabBarActionItem.this.rollover = false;
                TabBarActionItem.this.updateVisuals();
            }
        }
    }

    public static final class TabBarItem<T extends Tab> {
        private final TabBar<T> bar;
        private final TabModel<T> model;
        private final T tab;
        private boolean rollover = false;
        private boolean clickRollover = false;
        private JLabel label;
        private JLabel clickIcon;
        private JComponent clickBackground;
        private JComponent hideLabelEnd;
        private JComponent separator;
        private JPanel panel;
        private final PropertyChangeListener propertyListener;
        private final MouseAdapter mouseHandler;
        private final MouseListener clickMouseHandler;

        TabBarItem(TabBar<T> bar, TabModel<T> model, T tab) {
            this.bar = bar;
            this.model = model;
            this.tab = tab;
            this.initComponents();
            this.propertyListener = this::onViewPropertyChange;
            this.mouseHandler = new MouseHandler();
            this.clickMouseHandler = new ClickMouseHandler();
            this.initEventHandling();
        }

        private void initComponents() {
            this.label = new JLabel((Icon)null);
            this.label.setIconTextGap(ScreenScaling.toPhysical(8));
            this.label.setFont(resources.getTabBarFont());
            this.clickIcon = new JLabel((Icon)null);
            this.clickBackground = new JPanel(null);
            this.clickBackground.setPreferredSize(ScreenScaling.physicalDimension(20, 24));
            this.hideLabelEnd = new JPanel(null);
            this.separator = new JPanel(null);
            this.separator.setBackground(TAB_SEPARATOR);
            this.panel = new JPanel(null);
        }

        private void initEventHandling() {
            if (this.tab instanceof ObservableBean) {
                ((ObservableBean)this.tab).addPropertyChangeListener(this.propertyListener);
            }
            this.panel.addMouseListener(this.mouseHandler);
            this.panel.addMouseMotionListener(this.mouseHandler);
            this.clickBackground.addMouseListener(this.clickMouseHandler);
            this.updateLabel();
            this.updateVisuals();
        }

        void release() {
            if (this.tab instanceof ObservableBean) {
                ((ObservableBean)this.tab).removePropertyChangeListener(this.propertyListener);
            }
            this.panel.removeMouseListener(this.mouseHandler);
            this.clickBackground.removeMouseListener(this.clickMouseHandler);
        }

        private boolean isSelected() {
            return this.model.getSelectedTab() == this.tab;
        }

        private boolean isDragging() {
            return ((TabBar)this.bar).isDragging();
        }

        private JComponent buildPanel() {
            ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("8epx, 16epx:grow, 4epx, 1epx", new Object[0])).rows("6epx, f:20epx:grow, 6epx", new Object[0])).panel(this.panel)).honorsVisibility(false)).opaque(true)).add(this.separator).xywh(4, 1, 1, 3)).add(this.clickIcon).xy(2, 2, "right, center")).add(this.clickBackground).xywh(2, 1, 2, 3, "right, fill")).add(this.hideLabelEnd).xyw(3, 2, 2)).add(this.label).xyw(2, 2, 2, "left, center")).build();
            int minimumWidth = 32;
            int preferredWidth = 200;
            int tabWidth = this.tab.getPreferredTabWidth();
            if (tabWidth != -1) {
                preferredWidth = tabWidth;
            }
            this.panel.setMinimumSize(ScreenScaling.physicalDimension(minimumWidth, 24));
            this.panel.setPreferredSize(ScreenScaling.physicalDimension(preferredWidth, 24));
            return this.panel;
        }

        private void updateVisuals() {
            if (this.isDragging()) {
                return;
            }
            Locale locale = this.bar.getLocale();
            Icon icon = this.tab.isPinned() ? null : (this.clickRollover ? resources.getTabBarCloseTabResource(locale).getRolloverIcon() : resources.getTabBarCloseTabResource(locale).getIcon());
            boolean hasIcon = icon != null && (this.tab.isCloseEnabled() || this.tab.isPinned());
            boolean iconVisible = hasIcon && (this.isSelected() || this.rollover);
            Color background = INACTIVE;
            if (this.isSelected()) {
                background = ACTIVE;
            } else if (this.rollover) {
                background = INACTIVE_ROLLOVER;
            }
            this.clickIcon.setIcon(icon);
            this.clickIcon.setVisible(iconVisible);
            this.clickBackground.setVisible(iconVisible);
            this.clickBackground.setToolTipText(this.tab.isPinned() ? this.tab.getToolTipText() : resources.getTabBarCloseTabResource(locale).getMandatoryToolTipTextWithAccelerator(this.bar));
            this.clickBackground.setBackground(background);
            this.hideLabelEnd.setBackground(background);
            this.panel.setBackground(background);
        }

        private void updateLabel() {
            this.label.setIcon(this.tab.getIcon());
            this.label.setText(this.tab.getTitle());
            this.panel.setToolTipText(this.tab.getToolTipText());
        }

        private void updateRolloverState() {
            if (!this.panel.isShowing()) {
                return;
            }
            boolean oldRollover = this.rollover;
            this.rollover = TabBar.containsMouse(this.panel);
            boolean oldCloseRollover = this.clickRollover;
            this.clickRollover = TabBar.containsMouse(this.clickBackground);
            if (oldRollover != this.rollover || oldCloseRollover != this.clickRollover) {
                this.updateVisuals();
            }
        }

        private void onContextMenuRequested(MouseEvent evt) {
            this.tab.onContextMenuRequested(evt);
        }

        private void onViewPropertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "icon": 
                case "title": {
                    this.updateLabel();
                    break;
                }
                case "closeable": {
                    this.updateVisuals();
                    break;
                }
                case "pinned": {
                    this.updateVisuals();
                    break;
                }
            }
        }

        private final class ClickMouseHandler
        extends MouseAdapter {
            private ClickMouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isConsumed() || !TabBarItem.this.tab.isPinned()) {
                    return;
                }
                if (evt.isPopupTrigger()) {
                    TabBarItem.this.onContextMenuRequested(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isConsumed() || !TabBarItem.this.tab.isPinned()) {
                    return;
                }
                TabBarItem.this.model.setSelectedTab(TabBarItem.this.tab);
                if (evt.isPopupTrigger()) {
                    TabBarItem.this.onContextMenuRequested(evt);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (TabBarItem.this.tab.isCloseable()) {
                    TabBarItem.this.model.closeTab(evt, TabBarItem.this.tab);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TabBarItem.this.rollover = true;
                TabBarItem.this.clickRollover = true;
                TabBarItem.this.updateVisuals();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TabBarItem.this.rollover = false;
                TabBarItem.this.clickRollover = false;
                TabBarItem.this.updateVisuals();
            }
        }

        private final class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isConsumed()) {
                    return;
                }
                TabBarItem.this.model.setSelectedTab(TabBarItem.this.tab);
                if (evt.isPopupTrigger()) {
                    TabBarItem.this.onContextMenuRequested(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isConsumed()) {
                    return;
                }
                if (TabBarItem.this.bar.tabDragEnded(evt)) {
                    TabBarItem.this.bar.updateAllRolloverState();
                    return;
                }
                if (evt.isPopupTrigger()) {
                    TabBarItem.this.onContextMenuRequested(evt);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TabBarItem.this.rollover = true;
                TabBarItem.this.updateVisuals();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TabBarItem.this.rollover = false;
                TabBarItem.this.updateVisuals();
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                TabBarItem.this.bar.tabDragged(evt, TabBarItem.this);
            }
        }
    }
}

