/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.table;

import com.jgoodies.application.Application;
import com.jgoodies.common.base.Preconditions;
import java.util.prefs.Preferences;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class TableStateUtils {
    private static TableStateHandler handler;

    private TableStateUtils() {
    }

    public static TableStateHandler getHandler() {
        if (handler == null) {
            handler = new DefaultTableStateHandler();
        }
        return handler;
    }

    public static void setHandler(TableStateHandler newHandler) {
        Preconditions.checkNotNull(newHandler, "The %s must not be null.", "new handler");
        handler = newHandler;
    }

    public static void restoreNowAndStoreOnChange(JTable table, String id) {
        Preferences userRoot = Application.getInstance().getContext().getUserPreferences();
        Preferences tableStateNode = userRoot.node("tables");
        TableStateUtils.restoreNowAndStoreOnChange(table, tableStateNode.node(id));
    }

    public static void restoreNowAndStoreOnChange(JTable table, Preferences prefs) {
        TableStateUtils.getHandler().restore(table, prefs);
        TableStateUtils.getHandler().registerListeners(table, prefs);
    }

    public static class DefaultTableStateHandler
    implements TableStateHandler {
        @Override
        public void store(Preferences prefs, JTable table) {
            Preconditions.checkNotNull(prefs, "The %s must not be null.", "preferences");
            Preconditions.checkNotNull(table, "The %s must not be null.", "table");
            TableColumnModel columnModel = table.getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                TableColumn column = columnModel.getColumn(i);
                int modelIndex = column.getModelIndex();
                prefs.putInt(DefaultTableStateHandler.keyColumnIndex(i), modelIndex);
                prefs.putInt(DefaultTableStateHandler.keyColumnWidth(i), column.getWidth());
            }
        }

        @Override
        public void restore(JTable table, Preferences prefs) {
            int i;
            Preconditions.checkNotNull(prefs, "The %s must not be null.", "preferences");
            Preconditions.checkNotNull(table, "The %s must not be null.", "table");
            TableColumnModel columnModel = table.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            TableColumn[] backup = new TableColumn[columnCount];
            for (i = columnCount - 1; i >= 0; --i) {
                backup[i] = columnModel.getColumn(i);
                columnModel.removeColumn(columnModel.getColumn(i));
            }
            for (i = 0; i < columnCount; ++i) {
                int modelIndex = prefs.getInt(DefaultTableStateHandler.keyColumnIndex(i), i);
                TableColumn column = backup[modelIndex];
                columnModel.addColumn(column);
                column.setModelIndex(modelIndex);
                int width = prefs.getInt(DefaultTableStateHandler.keyColumnWidth(i), -1);
                if (width == -1) continue;
                column.setPreferredWidth(width);
            }
        }

        @Override
        public void registerListeners(JTable table, Preferences prefs) {
            table.getColumnModel().addColumnModelListener(new TableColumnChangeHandler(prefs, table));
        }

        private static String keyColumnIndex(int index) {
            return "col[" + index + "].index";
        }

        private static String keyColumnWidth(int index) {
            return "col[" + index + "].width";
        }

        private static final class TableColumnChangeHandler
        implements TableColumnModelListener {
            private final Preferences prefs;
            private final JTable table;

            TableColumnChangeHandler(Preferences prefs, JTable table) {
                this.prefs = prefs;
                this.table = table;
            }

            @Override
            public void columnMarginChanged(ChangeEvent evt) {
                TableStateUtils.getHandler().store(this.prefs, this.table);
            }

            @Override
            public void columnMoved(TableColumnModelEvent evt) {
                TableStateUtils.getHandler().store(this.prefs, this.table);
            }

            @Override
            public void columnAdded(TableColumnModelEvent evt) {
                TableStateUtils.getHandler().store(this.prefs, this.table);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent evt) {
                TableStateUtils.getHandler().store(this.prefs, this.table);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent evt) {
            }
        }
    }

    public static interface TableStateHandler {
        public void store(Preferences var1, JTable var2);

        public void restore(JTable var1, Preferences var2);

        public void registerListeners(JTable var1, Preferences var2);
    }
}

