/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.loggers;

import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.Serializable;

public abstract class RefreshInfo
implements Serializable,
Product {
    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    @Override
    public String productPrefix() {
        return Product.productPrefix$(this);
    }

    public abstract Option<Object> fraction();

    public abstract boolean watching();

    public abstract boolean success();

    public abstract RefreshInfo withSuccess(boolean var1);

    public RefreshInfo() {
        Product.$init$(this);
    }

    public static final class CheckUpdateInfo
    extends RefreshInfo {
        private final Option<Object> currentTimeOpt;
        private final Option<Object> remoteTimeOpt;
        private final boolean isDone;
        private final boolean success;

        public Option<Object> currentTimeOpt() {
            return this.currentTimeOpt;
        }

        public Option<Object> remoteTimeOpt() {
            return this.remoteTimeOpt;
        }

        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public boolean success() {
            return this.success;
        }

        @Override
        public boolean watching() {
            return false;
        }

        public None$ fraction() {
            return None$.MODULE$;
        }

        public CheckUpdateInfo withRemoteTimeOpt(Option<Object> remoteTimeOpt) {
            return new CheckUpdateInfo(this.currentTimeOpt(), remoteTimeOpt, this.isDone(), this.success());
        }

        public CheckUpdateInfo withIsDone(boolean isDone) {
            return new CheckUpdateInfo(this.currentTimeOpt(), this.remoteTimeOpt(), isDone, this.success());
        }

        @Override
        public CheckUpdateInfo withSuccess(boolean success) {
            return new CheckUpdateInfo(this.currentTimeOpt(), this.remoteTimeOpt(), this.isDone(), success);
        }

        public String toString() {
            StringBuilder b = new StringBuilder("CheckUpdateInfo(");
            b.append(String.valueOf(this.currentTimeOpt()));
            b.append(", ");
            b.append(String.valueOf(this.remoteTimeOpt()));
            b.append(", ");
            b.append(String.valueOf(this.isDone()));
            b.append(", ");
            b.append(String.valueOf(this.success()));
            b.append(")");
            return b.toString();
        }

        public boolean canEqual(Object obj) {
            return obj != null && obj instanceof CheckUpdateInfo && true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!this.canEqual(obj)) return false;
            CheckUpdateInfo other = (CheckUpdateInfo)obj;
            if (!true) return false;
            Option<Object> option = this.currentTimeOpt();
            Option<Object> option2 = other.currentTimeOpt();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.remoteTimeOpt();
            Option<Object> option4 = other.remoteTimeOpt();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (this.isDone() != other.isDone()) return false;
            if (this.success() != other.success()) return false;
            return true;
        }

        public int hashCode() {
            int code = 17 + Statics.anyHash("CheckUpdateInfo");
            code = 37 * code + Statics.anyHash(this.currentTimeOpt());
            code = 37 * code + Statics.anyHash(this.remoteTimeOpt());
            code = 37 * code + (this.isDone() ? 1231 : 1237);
            code = 37 * code + (this.success() ? 1231 : 1237);
            return 37 * code;
        }

        @Override
        public String productPrefix() {
            return "CheckUpdateInfo";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this.currentTimeOpt();
                }
                case 1: {
                    return this.remoteTimeOpt();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean(this.isDone());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean(this.success());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(n2));
        }

        public CheckUpdateInfo(Option<Object> currentTimeOpt, Option<Object> remoteTimeOpt, boolean isDone, boolean success) {
            this.currentTimeOpt = currentTimeOpt;
            this.remoteTimeOpt = remoteTimeOpt;
            this.isDone = isDone;
            this.success = success;
        }
    }

    public static final class DownloadInfo
    extends RefreshInfo {
        private final long downloaded;
        private final long previouslyDownloaded;
        private final Option<Object> length;
        private final long startTime;
        private final boolean updateCheck;
        private final boolean watching;
        private final boolean success;

        public long downloaded() {
            return this.downloaded;
        }

        public long previouslyDownloaded() {
            return this.previouslyDownloaded;
        }

        public Option<Object> length() {
            return this.length;
        }

        public long startTime() {
            return this.startTime;
        }

        public boolean updateCheck() {
            return this.updateCheck;
        }

        @Override
        public boolean watching() {
            return this.watching;
        }

        @Override
        public boolean success() {
            return this.success;
        }

        @Override
        public Option<Object> fraction() {
            return this.length().map(x$1 -> (double)this.downloaded() / (double)x$1);
        }

        public Option<Object> rate() {
            long currentTime = System.currentTimeMillis();
            if (currentTime > this.startTime()) {
                return new Some<Object>(BoxesRunTime.boxToDouble((double)(this.downloaded() - this.previouslyDownloaded()) / (double)(System.currentTimeMillis() - this.startTime()) * 1000.0));
            }
            return None$.MODULE$;
        }

        public DownloadInfo withDownloaded(long downloaded) {
            return new DownloadInfo(downloaded, this.previouslyDownloaded(), this.length(), this.startTime(), this.updateCheck(), this.watching(), this.success());
        }

        public DownloadInfo withPreviouslyDownloaded(long previouslyDownloaded) {
            return new DownloadInfo(this.downloaded(), previouslyDownloaded, this.length(), this.startTime(), this.updateCheck(), this.watching(), this.success());
        }

        public DownloadInfo withLength(Option<Object> length) {
            return new DownloadInfo(this.downloaded(), this.previouslyDownloaded(), length, this.startTime(), this.updateCheck(), this.watching(), this.success());
        }

        public DownloadInfo withWatching(boolean watching) {
            return new DownloadInfo(this.downloaded(), this.previouslyDownloaded(), this.length(), this.startTime(), this.updateCheck(), watching, this.success());
        }

        @Override
        public DownloadInfo withSuccess(boolean success) {
            return new DownloadInfo(this.downloaded(), this.previouslyDownloaded(), this.length(), this.startTime(), this.updateCheck(), this.watching(), success);
        }

        public String toString() {
            StringBuilder b = new StringBuilder("DownloadInfo(");
            b.append(String.valueOf(this.downloaded()));
            b.append(", ");
            b.append(String.valueOf(this.previouslyDownloaded()));
            b.append(", ");
            b.append(String.valueOf(this.length()));
            b.append(", ");
            b.append(String.valueOf(this.startTime()));
            b.append(", ");
            b.append(String.valueOf(this.updateCheck()));
            b.append(", ");
            b.append(String.valueOf(this.watching()));
            b.append(", ");
            b.append(String.valueOf(this.success()));
            b.append(")");
            return b.toString();
        }

        public boolean canEqual(Object obj) {
            return obj != null && obj instanceof DownloadInfo && true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!this.canEqual(obj)) return false;
            DownloadInfo other = (DownloadInfo)obj;
            if (!true) return false;
            if (this.downloaded() != other.downloaded()) return false;
            if (this.previouslyDownloaded() != other.previouslyDownloaded()) return false;
            Option<Object> option = this.length();
            Option<Object> option2 = other.length();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.startTime() != other.startTime()) return false;
            if (this.updateCheck() != other.updateCheck()) return false;
            if (this.watching() != other.watching()) return false;
            if (this.success() != other.success()) return false;
            return true;
        }

        public int hashCode() {
            int code = 17 + Statics.anyHash("DownloadInfo");
            code = 37 * code + Statics.longHash(this.downloaded());
            code = 37 * code + Statics.longHash(this.previouslyDownloaded());
            code = 37 * code + Statics.anyHash(this.length());
            code = 37 * code + Statics.longHash(this.startTime());
            code = 37 * code + (this.updateCheck() ? 1231 : 1237);
            code = 37 * code + (this.watching() ? 1231 : 1237);
            code = 37 * code + (this.success() ? 1231 : 1237);
            return 37 * code;
        }

        @Override
        public String productPrefix() {
            return "DownloadInfo";
        }

        @Override
        public int productArity() {
            return 7;
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong(this.downloaded());
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this.previouslyDownloaded());
                }
                case 2: {
                    return this.length();
                }
                case 3: {
                    return BoxesRunTime.boxToLong(this.startTime());
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean(this.updateCheck());
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean(this.watching());
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean(this.success());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(n2));
        }

        public DownloadInfo(long downloaded, long previouslyDownloaded, Option<Object> length, long startTime, boolean updateCheck, boolean watching, boolean success) {
            this.downloaded = downloaded;
            this.previouslyDownloaded = previouslyDownloaded;
            this.length = length;
            this.startTime = startTime;
            this.updateCheck = updateCheck;
            this.watching = watching;
            this.success = success;
        }
    }
}

