/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class SvgSizeAnalyzer {
    private static final Pattern TRANSFORM_PATTERN = Pattern.compile("scale\\((?<scaleX>[0-9.]+) (?<scaleY>[0-9.]+)\\) rotate\\((?<rotate>[0-9.]+)\\) translate\\((?<translateX>[0-9.]+) (?<translateY>[0-9.]+)\\)", 32);
    private static final Pattern SVG_PATTERN = Pattern.compile("<svg width=\"(?<width>\\d+)(?<unit>p[tx])\" height=\"(?<height>\\d+)p[tx]\"(?<between>.*?>\\R<g.*?)transform=\"" + TRANSFORM_PATTERN.pattern(), 32);
    private final Matcher matcher;
    @Nullable
    private Integer width;
    @Nullable
    private Integer height;
    @Nullable
    private Double scaleX;
    @Nullable
    private Double scaleY;
    @Nullable
    private Double rotate;
    @Nullable
    private Double translateX;
    @Nullable
    private Double translateY;

    public static SvgSizeAnalyzer svg(String svg) {
        return new SvgSizeAnalyzer(SVG_PATTERN, svg);
    }

    public static SvgSizeAnalyzer transform(String transform2) {
        return new SvgSizeAnalyzer(TRANSFORM_PATTERN, transform2);
    }

    private SvgSizeAnalyzer(Pattern pattern, String input) {
        this.matcher = pattern.matcher(input);
        if (!this.matcher.find()) {
            throw new IllegalArgumentException("Generated SVG has not the expected format. There might be image size problems.");
        }
    }

    public String getSvg() {
        String size2 = this.width == null ? "width=\"" + this.getWidth() + this.getUnit() + "\" height=\"" + this.getHeight() + this.getUnit() + "\"" : "width=\"" + this.width + "px\" height=\"" + this.height + "px\"";
        return this.matcher.replaceFirst("<svg " + size2 + this.matcher.group("between") + "transform=\"" + this.getTransform());
    }

    public String getTransform() {
        String scale = this.scaleX == null ? "scale(" + this.getScaleX() + " " + this.getScaleY() + ") " : "scale(" + this.scaleX + " " + this.scaleY + ") ";
        String rot = this.rotate == null ? "rotate(" + this.getRotate() + ") " : "rotate(" + this.rotate + ") ";
        String translate = this.translateX == null ? "translate(" + this.getTranslateX() + " " + this.getTranslateY() + ")" : "translate(" + this.translateX + " " + this.translateY + ")";
        return scale + rot + translate;
    }

    public int getWidth() {
        return Integer.parseInt(this.matcher.group("width"));
    }

    public int getHeight() {
        return Integer.parseInt(this.matcher.group("height"));
    }

    public String getUnit() {
        return this.matcher.group("unit");
    }

    public double getScaleX() {
        return Double.parseDouble(this.matcher.group("scaleX"));
    }

    public double getScaleY() {
        return Double.parseDouble(this.matcher.group("scaleY"));
    }

    public double getRotate() {
        return Double.parseDouble(this.matcher.group("rotate"));
    }

    public double getTranslateX() {
        return Double.parseDouble(this.matcher.group("translateX"));
    }

    public double getTranslateY() {
        return Double.parseDouble(this.matcher.group("translateY"));
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setScale(double scaleX, double scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void setRotate(double rotate) {
        this.rotate = rotate;
    }

    public void setTranslate(double translateX, double translateY) {
        this.translateX = translateX;
        this.translateY = translateY;
    }
}

