/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import weka.core.Utils;
import weka.gui.ResultHistoryPanel;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;

public class GraphViewer
extends JPanel
implements Visible,
GraphListener,
UserRequestAcceptor,
Serializable,
BeanContextChild {
    private static final long serialVersionUID = -5183121972114900617L;
    protected BeanVisual m_visual;
    private transient JFrame m_resultsFrame = null;
    protected transient ResultHistoryPanel m_history;
    protected transient BeanContext m_beanContext = null;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);
    protected boolean m_design;

    public GraphViewer() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.appearanceFinal();
        }
    }

    protected void appearanceDesign() {
        this.setUpResultHistory();
        this.removeAll();
        this.m_visual = new BeanVisual("GraphViewer", "weka/gui/beans/icons/DefaultGraph.gif", "weka/gui/beans/icons/DefaultGraph_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        this.setUpResultHistory();
        this.add((Component)this.m_history, "Center");
    }

    public String globalInfo() {
        return "Graphically visualize trees or graphs produced by classifiers/clusterers.";
    }

    private void setUpResultHistory() {
        if (this.m_history == null) {
            this.m_history = new ResultHistoryPanel(null);
        }
        this.m_history.setBorder(BorderFactory.createTitledBorder("Graph list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -4984130887963944249L;

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = GraphViewer.this.m_history.getList().locationToIndex(e.getPoint());
                if (index != -1) {
                    String name = GraphViewer.this.m_history.getNameAtIndex(index);
                    GraphViewer.this.doPopup(name);
                }
            }
        });
    }

    @Override
    public void setBeanContext(BeanContext bc) {
        this.m_beanContext = bc;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else if (!GraphicsEnvironment.isHeadless()) {
            this.appearanceFinal();
        }
    }

    @Override
    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    @Override
    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.addVetoableChangeListener(name, vcl);
    }

    @Override
    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.removeVetoableChangeListener(name, vcl);
    }

    @Override
    public synchronized void acceptGraph(GraphEvent e) {
        ArrayList<Object> graphInfo = new ArrayList<Object>();
        if (this.m_history == null) {
            this.setUpResultHistory();
        }
        String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
        name = name + e.getGraphTitle();
        graphInfo.add(new Integer(e.getGraphType()));
        graphInfo.add(e.getGraphString());
        this.m_history.addResult(name, new StringBuffer());
        this.m_history.addObject(name, graphInfo);
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultGraph.gif", "weka/gui/beans/icons/DefaultGraph_animated.gif");
    }

    public void showResults() {
        if (this.m_resultsFrame == null) {
            if (this.m_history == null) {
                this.setUpResultHistory();
            }
            this.m_resultsFrame = Utils.getWekaJFrame("Graph Viewer", this.m_visual);
            this.m_resultsFrame.getContentPane().setLayout(new BorderLayout());
            this.m_resultsFrame.getContentPane().add((Component)this.m_history, "Center");
            this.m_resultsFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GraphViewer.this.m_resultsFrame.dispose();
                    GraphViewer.this.m_resultsFrame = null;
                }
            });
            this.m_resultsFrame.pack();
            this.m_resultsFrame.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this.m_visual));
            this.m_resultsFrame.setVisible(true);
        } else {
            this.m_resultsFrame.toFront();
        }
    }

    private void doPopup(String name) {
        JFrame jf;
        ArrayList graph = (ArrayList)this.m_history.getNamedObject(name);
        int grphType = (Integer)graph.get(0);
        String grphString = (String)graph.get(graph.size() - 1);
        if (grphType == 1) {
            jf = Utils.getWekaJFrame("Weka Classifier Tree Visualizer: " + name, this.m_resultsFrame);
            jf.getContentPane().setLayout(new BorderLayout());
            TreeVisualizer tv = new TreeVisualizer(null, grphString, (NodePlace)new PlaceNode2());
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.pack();
            jf.setSize(500, 400);
            jf.setLocationRelativeTo(this.m_resultsFrame);
            jf.setVisible(true);
        }
        if (grphType == 2) {
            jf = Utils.getWekaJFrame("Weka Classifier Graph Visualizer: " + name, this.m_resultsFrame);
            jf.getContentPane().setLayout(new BorderLayout());
            GraphVisualizer gv = new GraphVisualizer();
            try {
                gv.readBIF(grphString);
            }
            catch (BIFFormatException be) {
                System.err.println("unable to visualize BayesNet");
                be.printStackTrace();
            }
            gv.layoutGraph();
            jf.getContentPane().add((Component)gv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.pack();
            jf.setSize(500, 400);
            jf.setLocationRelativeTo(this.m_resultsFrame);
            jf.setVisible(true);
        }
    }

    @Override
    public Enumeration<String> enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        newVector.addElement("Show results");
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Show results") != 0) {
            throw new IllegalArgumentException(request + " not supported (GraphViewer)");
        }
        this.showResults();
    }
}

