/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.project;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dita.dost.project.ProjectBuilder;

public record Project(List<Deliverable> deliverables, List<ProjectRef> includes, List<Publication> publications, List<Context> contexts) {
    public static Project build(ProjectBuilder src, URI base) {
        Project project = new Project(Project.toStream(src.deliverables).map(deliverable -> new Deliverable(deliverable.name, deliverable.id, Project.build(deliverable.context, base), deliverable.output, Project.build(deliverable.publication, base))).collect(Collectors.toList()), Project.toStream(src.includes).map(include -> new ProjectRef(Project.resolveURI(include, base))).collect(Collectors.toList()), Project.toStream(src.publications).map(publication -> Project.build(publication, base)).collect(Collectors.toList()), Project.toStream(src.contexts).map(context -> Project.build(context, base)).collect(Collectors.toList()));
        return project;
    }

    private static <T> Stream<T> toStream(List<T> src) {
        return src != null ? src.stream() : Stream.empty();
    }

    private static URI resolveURI(URI file, URI base) {
        if (file == null) {
            return null;
        }
        return base != null ? base.resolve(file) : file;
    }

    private static Path resolvePath(URI file, URI base) {
        if (file == null) {
            return null;
        }
        return base != null ? Paths.get(base.resolve(file)) : Paths.get(file);
    }

    private static Publication build(ProjectBuilder.Publication publication, URI base) {
        if (publication == null) {
            return null;
        }
        return new Publication(publication.name, publication.id, publication.idref, publication.transtype, Project.toStream(publication.params).map(param -> new Publication.Param(param.name, param.value, Project.resolveURI(param.href, base), Project.resolvePath(param.path, base))).collect(Collectors.toList()), new Deliverable.Profile(publication.profiles != null ? publication.profiles.ditavals.stream().map(ditaval -> new Deliverable.Profile.DitaVal(Project.resolveURI(ditaval, base))).collect(Collectors.toList()) : Collections.emptyList()));
    }

    private static Context build(ProjectBuilder.Context context, URI base) {
        if (context == null) {
            return null;
        }
        return new Context(context.name, context.id, context.idref, context.input != null ? new Deliverable.Inputs(context.input.stream().map(input -> new Deliverable.Inputs.Input(Project.resolveURI(input, base))).collect(Collectors.toList())) : new Deliverable.Inputs(Collections.emptyList()), new Deliverable.Profile(context.profiles != null ? context.profiles.ditavals.stream().map(ditaval -> new Deliverable.Profile.DitaVal(Project.resolveURI(ditaval, base))).collect(Collectors.toList()) : Collections.emptyList()));
    }

    public record Publication(String name, String id, String idref, String transtype, List<Param> params, Deliverable.Profile profiles) {

        public record Param(String name, String value, URI href, Path path) {
            public Param {
                Objects.requireNonNull(name);
                if (value == null && href == null && path == null) {
                    throw new NullPointerException();
                }
            }
        }
    }

    public record Deliverable(String name, String id, Context context, URI output, Publication publication) {

        public record Profile(List<DitaVal> ditavals) {

            public record DitaVal(URI href) {
            }
        }

        public record Inputs(List<Input> inputs) {

            public record Input(URI href) {
            }
        }
    }

    public record Context(String name, String id, String idref, Deliverable.Inputs inputs, Deliverable.Profile profiles) {
    }

    public record ProjectRef(URI href) {
    }
}

