/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0082\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "checkContainingClasses", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInImportsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInImportsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1869#2,2:60\n*S KotlinDebug\n*F\n+ 1 FirOptInImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInImportsChecker\n*L\n28#1:60,2\n*E\n"})
public final class FirOptInImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirOptInImportsChecker INSTANCE = new FirOptInImportsChecker();

    private FirOptInImportsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFile declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Iterable $this$forEach$iv = declaration.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirRegularClassSymbol expandedClassSymbol;
            KtSourceElement source;
            FirClassLikeSymbol<?> parentClassSymbol;
            ClassId resolvedParentClassId;
            FirImport firImport = (FirImport)element$iv;
            boolean bl = false;
            if (!(firImport instanceof FirResolvedImport) || ((FirResolvedImport)firImport).getSource() == null || ((FirResolvedImport)firImport).getResolvedParentClassId() == null || FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId(resolvedParentClassId) == null) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = parentClassSymbol;
            if (firClassLikeSymbol instanceof FirRegularClassSymbol) {
                INSTANCE.checkContainingClasses(parentClassSymbol, source, context2, reporter);
                continue;
            }
            if (!(firClassLikeSymbol instanceof FirTypeAliasSymbol) || DeclarationUtilsKt.fullyExpandedClass(parentClassSymbol, context2.getSession()) == null) continue;
            INSTANCE.checkContainingClasses(expandedClassSymbol, source, context2, reporter);
        }
    }

    private final void checkContainingClasses(FirClassLikeSymbol<?> $this$checkContainingClasses, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        FirOptInImportsChecker firOptInImportsChecker = this;
        while (true) {
            Object object;
            if (FirOptInUsageBaseChecker.INSTANCE.isExperimentalMarker((FirClassLikeSymbol<?>)$this$checkContainingClasses, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context2, null, 8, null);
            }
            if ((object = ClassMembersKt.getContainingClassLookupTag($this$checkContainingClasses)) == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context2.getSession())) == null) {
                return;
            }
            Object containingClassSymbol = object;
            FirOptInImportsChecker firOptInImportsChecker2 = firOptInImportsChecker;
            KtSourceElement ktSourceElement = source;
            CheckerContext checkerContext = context2;
            DiagnosticReporter diagnosticReporter = reporter;
            firOptInImportsChecker = firOptInImportsChecker2;
            $this$checkContainingClasses = containingClassSymbol;
            source = ktSourceElement;
            context2 = checkerContext;
            reporter = diagnosticReporter;
        }
    }
}

