/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.util.Path;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.Nullable;

public class DefaultGroupTaskReportModel
implements TaskReportModel {
    public static final String OTHER_GROUP = "other";
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    private final SetMultimap<String, TaskDetails> groups;

    public static DefaultGroupTaskReportModel of(TaskReportModel model) {
        Comparator keyComparator = GUtil.last((Comparator)GUtil.last(STRING_COMPARATOR, (Object)OTHER_GROUP), (Object)"");
        Comparator<TaskDetails> taskComparator = new Comparator<TaskDetails>(){

            @Override
            public int compare(TaskDetails task1, TaskDetails task2) {
                int diff = STRING_COMPARATOR.compare(task1.getPath().getName(), task2.getPath().getName());
                if (diff != 0) {
                    return diff;
                }
                Path parent1 = task1.getPath().getParent();
                Path parent2 = task2.getPath().getParent();
                if (parent1 == null && parent2 != null) {
                    return -1;
                }
                if (parent1 != null && parent2 == null) {
                    return 1;
                }
                if (parent1 == null) {
                    return 0;
                }
                return parent1.compareTo(parent2);
            }
        };
        TreeMultimap groups = TreeMultimap.create((Comparator)keyComparator, (Comparator)taskComparator);
        for (String group : model.getGroups()) {
            groups.putAll((Object)group, model.getTasksForGroup(group));
        }
        String otherGroupName = DefaultGroupTaskReportModel.findOtherGroup(groups.keySet());
        if (otherGroupName != null && groups.keySet().contains("")) {
            groups.putAll((Object)otherGroupName, (Iterable)groups.removeAll((Object)""));
        }
        if (groups.keySet().contains("") && groups.keySet().size() > 1) {
            groups.putAll((Object)OTHER_GROUP, (Iterable)groups.removeAll((Object)""));
        }
        return new DefaultGroupTaskReportModel((SetMultimap<String, TaskDetails>)groups);
    }

    private DefaultGroupTaskReportModel(SetMultimap<String, TaskDetails> groups) {
        this.groups = groups;
    }

    private static @Nullable String findOtherGroup(Set<String> groupNames) {
        for (String groupName : groupNames) {
            if (!groupName.equalsIgnoreCase(OTHER_GROUP)) continue;
            return groupName;
        }
        return null;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        return this.groups.get((Object)group);
    }
}

