/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class AttributeUtils {
    public static void chmod(@Nonnull File file, int mode) throws IOException {
        Path path = file.toPath();
        if (!Files.isSymbolicLink(path)) {
            Files.setPosixFilePermissions(path, AttributeUtils.getPermissions(mode));
        }
    }

    @Nonnull
    public static Set<PosixFilePermission> getPermissions(int mode) {
        HashSet<PosixFilePermission> perms2 = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) > 0) {
            perms2.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) > 0) {
            perms2.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) > 0) {
            perms2.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) > 0) {
            perms2.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) > 0) {
            perms2.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) > 0) {
            perms2.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) > 0) {
            perms2.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) > 0) {
            perms2.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) > 0) {
            perms2.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms2;
    }
}

