/*
 * Decompiled with CFR 0.152.
 */
package mill.runner;

import fansi.Str$;
import java.io.InputStream;
import java.io.Serializable;
import mill.api.SystemStreams;
import mill.moduledefs.Scaladoc;
import mill.runner.Watching;
import mill.util.Colors;
import mill.util.Watchable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n * Logic around the \"watch and wait\" functionality in Mill: re-run on change,\n * re-run when the user presses Enter, printing status messages, etc.\n */")
public final class Watching$ {
    public static final Watching$ MODULE$ = new Watching$();

    public <T> Tuple2<Object, T> watchLoop(boolean ringBell, boolean watch, SystemStreams streams, Function1<Object, BoxedUnit> setIdle, Function2<Object, Option<T>, Watching.Result<T>> evaluate, Colors colors) {
        Option prevState = None$.MODULE$;
        boolean enterKeyPressed = false;
        while (true) {
            Watching.Result<T> result2;
            if ((result2 = evaluate.apply(BoxesRunTime.boxToBoolean(enterKeyPressed), prevState)) == null) {
                throw new MatchError(result2);
            }
            Seq<Watchable> watchables = result2.watched();
            Option<String> errorOpt = result2.error();
            T result3 = result2.result();
            Tuple3<Seq<Watchable>, Option<String>, T> tuple3 = new Tuple3<Seq<Watchable>, Option<String>, T>(watchables, errorOpt, result3);
            Seq<Watchable> watchables2 = tuple3._1();
            Option<String> errorOpt2 = tuple3._2();
            T result4 = tuple3._3();
            prevState = new Some<T>(result4);
            errorOpt2.foreach((Function1<String, Object> & Serializable)x$1 -> {
                Watching$.$anonfun$watchLoop$1(streams, x$1);
                return BoxedUnit.UNIT;
            });
            if (ringBell) {
                if (errorOpt2.isEmpty()) {
                    Predef$.MODULE$.println("\u0007");
                } else {
                    Predef$.MODULE$.println("\u0007");
                    Thread.sleep(250L);
                    Predef$.MODULE$.println("\u0007");
                }
            }
            if (!watch) {
                return new Tuple2<Boolean, T>(BoxesRunTime.boxToBoolean(errorOpt2.isEmpty()), result4);
            }
            boolean alreadyStale = watchables2.exists((Function1<Watchable, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(Watching$.$anonfun$watchLoop$2(x$2)));
            enterKeyPressed = false;
            if (alreadyStale) continue;
            enterKeyPressed = this.watchAndWait(streams, setIdle, streams.in(), watchables2, colors);
        }
    }

    public boolean watchAndWait(SystemStreams streams, Function1<Object, BoxedUnit> setIdle, InputStream stdin, Seq<Watchable> watched, Colors colors) {
        setIdle.apply(BoxesRunTime.boxToBoolean(true));
        Seq watchedPaths = (Seq)watched.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Watchable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Watchable.Path) {
                    Watchable.Path path = (Watchable.Path)A1;
                    return (B1)path.p().path();
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Watchable x1) {
                Watchable watchable = x1;
                return watchable instanceof Watchable.Path;
            }
        });
        int watchedValues = watched.size() - watchedPaths.size();
        String watchedValueStr = watchedValues == 0 ? "" : new StringBuilder(18).append(" and ").append(watchedValues).append(" other values").toString();
        streams.err().println(colors.info().apply(Str$.MODULE$.implicitApply(new StringBuilder(67).append("Watching for changes to ").append(watchedPaths.size()).append(" paths").append(watchedValueStr).append("... (Enter to re-run, Ctrl-C to exit)").toString())).toString());
        boolean enterKeyPressed = this.statWatchWait(watched, stdin);
        setIdle.apply(BoxesRunTime.boxToBoolean(false));
        return enterKeyPressed;
    }

    public boolean statWatchWait(Seq<Watchable> watched, InputStream stdin) {
        byte[] buffer = new byte[4096];
        return this.statWatchWait0$1(watched, stdin, buffer);
    }

    public static final /* synthetic */ void $anonfun$watchLoop$1(SystemStreams streams$1, String x$1) {
        streams$1.err().println(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$watchLoop$2(Watchable x$2) {
        return !x$2.validate();
    }

    private final boolean statWatchWait0$1(Seq watched$1, InputStream stdin$1, byte[] buffer$1) {
        while (watched$1.forall((Function1<Watchable, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.validate()))) {
            if (this.lookForEnterKey$1(stdin$1, buffer$1)) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    private final boolean lookForEnterKey$1(InputStream stdin$1, byte[] buffer$1) {
        block6: while (true) {
            if (stdin$1.available() == 0) {
                return false;
            }
            int n = stdin$1.read(buffer$1);
            switch (n) {
                case -1: 
                case 0: {
                    return false;
                }
            }
            Object qual$1 = Predef$.MODULE$.byteArrayOps(buffer$1);
            int x$1 = 10;
            int x$2 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$1);
            int n2 = ArrayOps$.MODULE$.indexOf$extension(qual$1, BoxesRunTime.boxToByte((byte)10), x$2);
            switch (n2) {
                case -1: {
                    continue block6;
                }
            }
            if (n2 < n) break;
        }
        return true;
    }

    private Watching$() {
    }
}

