/*  This file is part of FreeDoko.
    FreeDoko is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version (see <http://www.gnu.org/licenses/>).

    Diese Datei ist Teil von FreeDoko.
    FreeDoko ist Freie Software: Sie können es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation, Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren veröffentlichten Version, weiter verteilen und/oder modifizieren (siehe <https://www.gnu.org/licenses/>).
    */

#pragma once

#include "constants.h"

#include "pfund.h"

namespace Heuristics {

/** Pfund in the first color run, if the trick goes to the partner
 **/
class PfundInFirstColorRun : public Pfund {
public:
static bool is_valid(GameTypeGroup game_type, PlayerTypeGroup player_group);

public:
explicit PfundInFirstColorRun(Ai const& ai);
PfundInFirstColorRun(PfundInFirstColorRun const&) = delete;
PfundInFirstColorRun& operator=(PfundInFirstColorRun const&) = delete;

~PfundInFirstColorRun() override;

bool conditions_met(Trick const& trick) override;
Card card_to_play(Trick const& trick) override;

private:
bool condition_winnercard_ace_or_trump(Trick const& trick);
Card choose_best_fehl(Trick const& trick);
};
} // namespace Heuristics
