/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.ValidationTask;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ValidateUploadHook
implements UploadHook {
    @Override
    public boolean checkUpload(APIDataSet apiDataSet) {
        AtomicBoolean returnCode = new AtomicBoolean();
        HashSet<OsmPrimitive> toCheck = new HashSet<OsmPrimitive>();
        toCheck.addAll(apiDataSet.getPrimitivesToAdd());
        toCheck.addAll(apiDataSet.getPrimitivesToUpdate());
        OsmValidator.initializeTests();
        new ValidationTask(errors -> {
            if (errors.stream().allMatch(TestError::isIgnored)) {
                returnCode.set(true);
            } else {
                GuiHelper.runInEDTAndWait(() -> returnCode.set(ValidateUploadHook.displayErrorScreen(errors)));
            }
        }, null, OsmValidator.getEnabledTests(true), toCheck, null, true).run();
        return returnCode.get();
    }

    private static boolean displayErrorScreen(List<TestError> errors) {
        JPanel p = new JPanel(new GridBagLayout());
        ValidatorTreePanel errorPanel = new ValidatorTreePanel(errors);
        errorPanel.expandAll();
        HtmlPanel pnlMessage = new HtmlPanel();
        pnlMessage.setText("<html><body>" + I18n.tr("The JOSM data validator partially checked the objects to be uploaded and found some problems. Try fixing them, but do not harm valid data. When in doubt ignore the findings.<br> You can see the findings in the Validator Results panel too. Further checks on all data can be started from that panel.", new Object[0]) + "<table align=\"center\"><tr><td align=\"left\"><b>" + I18n.tr("Errors", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Usually this should be fixed.", new Object[0]) + "</td></tr><tr><td align=\"left\"><b>" + I18n.tr("Warnings", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Fix these when possible.", new Object[0]) + "</td></tr><tr><td align=\"left\"><b>" + I18n.tr("Other", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Informational hints, expect many false entries.", new Object[0]) + "</td></tr></table>");
        pnlMessage.setPreferredSize(new Dimension(500, 150));
        p.add((Component)pnlMessage, GBC.eol().fill(2));
        p.add((Component)new JScrollPane(errorPanel), GBC.eol().fill(1));
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Suspicious data found. Upload anyway?", new Object[0]), I18n.tr("Continue upload", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("ok", "cancel").setContent(p);
        int rc = ed.showDialog().getValue();
        GuiHelper.destroyComponents(ed, false);
        ed.dispose();
        return rc == 1;
    }
}

