/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.internal;

import jakarta.annotation.Nonnull;
import java.beans.ConstructorProperties;

public class DefaultEndpointConfiguration {
    private static final String SERVICE_ENDPOINT_PREFIX_TEMPLATE = "{serviceEndpointPrefix}";
    private static final String REGION_ID_TEMPLATE = "{region}";
    private static final String SECOND_LEVEL_DOMAIN_TEMPLATE = "{secondLevelDomain}";
    private static final String ENDPOINT_SERVICE_NAME_TEMPLATE = "{endpointServiceName}";
    private final String endpointTemplate;
    private String serviceEndpointPrefix;
    private String regionId;
    private String secondLevelDomain;
    private String endpointServiceName;

    public static DefaultEndpointConfiguration builder(@Nonnull String endpointTemplate) {
        if (endpointTemplate == null) {
            throw new NullPointerException("endpointTemplate is marked non-null but is null");
        }
        return new DefaultEndpointConfiguration(endpointTemplate);
    }

    public DefaultEndpointConfiguration serviceEndpointPrefix(String serviceEndpointPrefix) {
        this.serviceEndpointPrefix = serviceEndpointPrefix;
        return this;
    }

    public DefaultEndpointConfiguration regionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    public DefaultEndpointConfiguration secondLevelDomain(String secondLevelDomain) {
        this.secondLevelDomain = secondLevelDomain;
        return this;
    }

    public DefaultEndpointConfiguration endpointServiceName(String endpointServiceName) {
        this.endpointServiceName = endpointServiceName;
        return this;
    }

    public String build() {
        String endpoint = this.endpointTemplate;
        if (this.serviceEndpointPrefix != null) {
            endpoint = endpoint.replace(SERVICE_ENDPOINT_PREFIX_TEMPLATE, this.serviceEndpointPrefix);
        }
        if (this.regionId != null) {
            endpoint = endpoint.replace(REGION_ID_TEMPLATE, this.regionId);
        }
        if (this.secondLevelDomain != null) {
            endpoint = endpoint.replace(SECOND_LEVEL_DOMAIN_TEMPLATE, this.secondLevelDomain);
        }
        if (this.endpointServiceName != null) {
            endpoint = endpoint.replace(ENDPOINT_SERVICE_NAME_TEMPLATE, this.endpointServiceName);
        }
        return endpoint;
    }

    @ConstructorProperties(value={"endpointTemplate"})
    private DefaultEndpointConfiguration(String endpointTemplate) {
        this.endpointTemplate = endpointTemplate;
    }
}

