/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupListByPathRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.Group;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListGroupsRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListGroupsResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IAMGroupListByPathDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupListByPathDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupListByPathRequest) {
            LOG.debug((Object)("Listing groups " + request));
            GroupListByPathRequest req = (GroupListByPathRequest)request;
            ListGroupsRequest listGroupsRequest = new ListGroupsRequest();
            listGroupsRequest.setPathPrefix(req.getPath());
            listGroupsRequest.setMarker(req.getMarker());
            listGroupsRequest.setMaxItems(req.getMaxItems());
            LOG.debug((Object)"Listing groups under path prefix");
            ListGroupsResult listGroupsResult = this.getClient().listGroups(listGroupsRequest);
            if (!listGroupsResult.getGroups().isEmpty()) {
                for (Group group : listGroupsResult.getGroups()) {
                    LOG.info((Object)group.getArn());
                }
            }
            LOG.info((Object)("IsTruncated: " + listGroupsResult.getIsTruncated()));
            if (listGroupsResult.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + listGroupsResult.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

